const express = require("express");
const router = express.Router();
const {
  createContact,
  getAllContacts,
  getContact,
  updateContactStatus,
  getNotifications,
  deleteContact,
} = require("../controllers/contactController");
const authController = require("../controllers/authController");
// Route: /api/contact

// Public: Send a message
router.post("/", createContact);

router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));
router.get("/notifications", getNotifications);
router.get("/", getAllContacts);
router.get("/:id", getContact);
// Private (Admin): Update status (e.g., mark as Read)
router.patch("/:id", updateContactStatus);
router.delete("/:id", deleteContact);
module.exports = router;
